rule Detect_TCP_Socket_Usage
{
    meta:
        description = "Detects TCP socket setup (used in backdoors/malware)"
        author = "MAT"
        threat = "TCP Socket Setup"
    
    strings:
	$f1 = "Ws2_32.dll" nocase
	$f1 = "wsock32.dll" nocase
	$s1 = "socket" // Create socket
	$s2 = "connect" // Connect to server
	$s3 = "send" // Send data
	$s4 = "recv" // Receive data
    condition:
        all of ($s*) and all of ($f*)
}
