rule Is_PE_EXE
{
    meta:
        description = "Detects Windows PE executable (EXE) files"
        author = "MAT"
        file_type = "EXE"
    
    strings:
        $mz = { 4D 5A }           // MZ magic number
        $pe = { 50 45 00 00 }     // PE\0\0 signature
        
    condition:
        $mz at 0 and $pe in (0..512)   // MZ at start, PE shortly after
}
