/*
Set of rules for Grasshopper APT.
Infected DLL hashes of Stolen Goods 2.1.
Ref: https://wikileaks.org/vault7/document/StolenGoods-2_1-UserGuide/StolenGoods-2_1-UserGuide.pdf

Author: Jaume Martin
Date: 07-04-2017
*/

import "hash"

rule Control32 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "b3dc808fc7cb4492669ec019911ef22a"
}

rule Control64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "bec30379078d5c5c7845d3be33707b89"
}

rule GH_PM32 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "2f2c5b3f3b1f97908074f526ac90a28d"
}

rule GH_PM64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "fe6c0097412b2c7b7f4b8a489004dd14"
}

rule MemStub32_GH1 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "0a579ad25fdd4db8110aac4dbb7d2da3"
}

rule MemStub32 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "8987652f26732607b769247adb4e9cce"
}

rule MemStub64_GH1 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "2350403a09e6928f0a7ba5d74da58cb9"
}

rule MemStub64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "6b5b46d3212fc3fc5b455d9efd8d3ffa"
}

rule msvcrt_Win7AMD64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "c8fc794cc5a22b5a1e0803b0b8acce77"
}

rule msvcrt_Win7x86 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "7713e5c5a48b020c9575b1b50f2e5e9e"
}

rule msvcrt_WIN8AMD64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "33c59fcdf027470e0ab1d366f54a6ebf"
}

rule msvcrt_WIN8x86 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "95490c2b284a9bb63f0ee49254ab727e"
}

rule msvcrt_WinXPx86 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "b68f72d77754f8b76168ced0924a4174"
}

rule Network_Win7AMD64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "eb92031a38f17d0e63285b5142b31966"
}

rule Network_Win7x86 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "548889baed7768b828d9c2f373abd225"
}

rule Network_WinXPx86 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "877341a16d5d223435c43a9db7f721bc"
}

rule RabbitStew32 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "a9d2e8ae5ddbf8f2842d96f7de2faef8"
}

rule RabbitStew64 {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "fa415b6280104e813770df520b303897"
}

rule Vbr {
    meta:
        author = "Jaume Martin"
    condition:
        hash.md5(0, filesize) == "961d2fd68fde2ae0b7c52e0c90767d0d"
}

