/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) 
    and open to any user or organization, as long as you use it under this license.

*/

rule Email_Generic_Phishing : email
{
  meta:
		Author = "Tyler <@InfoSecTyler>"
		Description ="Generic rule to identify phishing emails"

  strings:
    $eml_1="From:"
    $eml_2="To:"
    $eml_3="Subject:"

    $greeting_1="Hello sir/madam" nocase
    $greeting_2="Attention" nocase
    $greeting_3="Dear user" nocase
    $greeting_4="Account holder" nocase

    $url_1="Click" nocase
    $url_2="Confirm" nocase
    $url_3="Verify" nocase
    $url_4="Here" nocase
    $url_5="Now" nocase
    $url_6="Change password" nocase 

    $lie_1="Unauthorized" nocase
    $lie_2="Expired" nocase
    $lie_3="Deleted" nocase
    $lie_4="Suspended" nocase
    $lie_5="Revoked" nocase
    $lie_6="Unable" nocase

  condition:
    all of ($eml*) and
    any of ($greeting*) and
    any of ($url*) and
    any of ($lie*)
}
